load('resmatrix3p025.mat') 
%% plots with contour
%parameters
pt = 1.98;%2.3;
ptsd = 1.4;
ptsm = 1.4/sqrt(17);
pu = 0.63;
pusd = 0.12;
pusm = 0.12/sqrt(17);
pa = 0.72;
pasd = 0.21;
pasm = 0.21/sqrt(17);


[X,Y] = meshgrid(0:0.1:1);
[Xq,Yq] = meshgrid(0:0.01:1);
XX = 0:0.01:1;
f1 = fspecial('Gaussian',5,1);
S1= imfilter(RES1b,f1,'replicate');
S2= imfilter(1./RES2,f1,'replicate');
S3= imfilter(RES3,f1,'replicate');
V1q = interp2(X,Y,S1,Xq,Yq);
V1f = rot90(V1q.*5./60);
V2q = interp2(X,Y,S2,Xq,Yq);
V2f = rot90(V2q);
V3q = interp2(X,Y,S3,Xq,Yq);
V3f = rot90(V3q);
figure(1)
imagesc(XX,XX,V1f,[0 4.5])%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% alignement
v = [pa,pa];
contour(Xq,Yq,V3f,v,'y','linewidth',3)
v = [pa+pasm,pa+pasm];
contour(Xq,Yq,V3f,v,'y--','linewidth',1)
v = [pa-pasm,pa-pasm];
contour(Xq,Yq,V3f,v,'y--','linewidth',1)
% unicity
v = [pu,pu];
contour(Xq,Yq,V2f,v,'c','linewidth',3)
v = [pu+pusm,pu+pusm];
contour(Xq,Yq,V2f,v,'c--','linewidth',1)
v = [pu-pusm,pu-pusm];
contour(Xq,Yq,V2f,v,'c--','linewidth',1)
% persistence time
v = [pt,pt];
contour(Xq,Yq,V1f,v,'k','linewidth',3)
v = [pt+ptsm,pt+ptsm];
contour(Xq,Yq,V1f,v,'k','linewidth',1)
v = [pt-ptsm,pt-ptsm];
contour(Xq,Yq,V1f,v,'k','linewidth',1)

yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
 saveas(gcf,'newpers.png')
%%
figure(2)
imagesc(XX,XX,V2f)%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% unicity
v = [pu,pu];
contour(Xq,Yq,V2f,v,'k','linewidth',3)
v = [pu+pusm,pu+pusm];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)
v = [pu-pusm,pu-pusm];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)

yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
saveas(gcf,'newuni.png')

figure(3)
imagesc(XX,XX,V3f)%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% alignement
v = [pa,pa];
contour(Xq,Yq,V3f,v,'k','linewidth',3)
v = [pa+pasm,pa+pasm];
contour(Xq,Yq,V3f,v,'k--','linewidth',1)
v = [pa-pasm,pa-pasm];
contour(Xq,Yq,V3f,v,'k--','linewidth',1)

yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
saveas(gcf,'newali.png')